// Entry point for JavaScript code
App.onLaunch = function(options) {
  var javascriptFiles = [
    `${options.BASEURL}js/presenter.js`
  ];

  // Evaluate the scripts using evaluateScripts() – takes two arguments: An array of script URLs to evaluate
  // and a callback function (called only when ALL scripts are evaluated successfully)
  evaluateScripts(javascriptFiles, function(success) {
    if (success) {
      var alertDocument = createAlertDocument("Hello World");
      Presenter.presentDocument(alertDocument);
    } else {
      var alertDocument = createAlertDocument("Loading scripts failed!");
      Presenter.presentDocument(alertDocument);
    }
  });
}

var createAlertDocument = function(title) {
  // Create a template literal (ES6 specification) for an alertTemplate
  var alertXMLString = `<?xml version="1.0" encoding="UTF-8"?>
    <document>
      <alertTemplate>
        <title>${title}</title>
        <description></description>
        <button>
          <text>OK</text>
        </button>
      </alertTemplate>
    </document>`

  // Get the document
  return Presenter.getDocument(alertXMLString);
}
